#!/bin/bash
# =================================================================
# Btrfs 스냅샷 관리 스크립트 (UUID 버전)
# =================================================================
set -e # 오류 발생 시 즉시 중단

# --- 설정 ---
DEVICE="UUID=56870639-72c9-4a55-b0d2-81dfe499daa7"
ADMIN_MOUNT="/mnt/btrfs_admin"
KEEP_COUNT=4 # 보관할 스냅샷 개수

# --- 스크립트 본문 ---
echo "스냅샷 생성을 시작합니다..."

# 1. Btrfs 관리를 위해 최상위 루트를 임시 마운트
sudo mkdir -p "$ADMIN_MOUNT"
sudo mount -o subvolid=5 "$DEVICE" "$ADMIN_MOUNT"

# 2. 스냅샷 이름과 전체 경로 설정
SNAPSHOT_NAME="weekly-$(date +%Y-%m-%d_%H-%M-%S)"
FULL_SNAPSHOT_PATH="$ADMIN_MOUNT/snapshots/$SNAPSHOT_NAME"

echo "[1/3] 새 스냅샷 생성: $SNAPSHOT_NAME"
# 'work_data' 서브볼륨의 스냅샷을 'snapshots' 서브볼륨 안에 생성
if ! sudo btrfs subvolume snapshot -r "$ADMIN_MOUNT/work_data" "$FULL_SNAPSHOT_PATH"; then
    echo "오류: 스냅샷 생성 실패."
    sudo umount "$ADMIN_MOUNT"
    exit 1
fi

echo "[2/3] 오래된 스냅샷 정리..."
find "$ADMIN_MOUNT/snapshots/" -maxdepth 1 -type d -name "weekly-*" | sort | head -n -"$KEEP_COUNT" | xargs -r sudo btrfs subvolume delete

echo "[3/3] 관리용 임시 마운트 해제"
sudo umount "$ADMIN_MOUNT"

echo "✅ 스냅샷 작업이 성공적으로 완료되었습니다."
