#!/bin/bash
# =================================================================
# Btrfs USB SSD 마운트 스크립트
# =================================================================
set -e

echo "USB 작업을 위해 Btrfs 볼륨을 마운트합니다..."

# 1. ~/usb_work 에는 기본값('work_data')을 연결
sudo mount UUID="56870639-72c9-4a55-b0d2-81dfe499daa7" ~/usb_work

# 2. ~/usb_work/snapshot 에는 'snapshots' 서브볼륨을 소유자 권한으로 연결
# 이렇게 하면 snapshot 폴더 안에서 sudo 없이 스냅샷 생성/삭제가 가능해집니다.
sudo mount -o subvol=snapshots,uid=$(id -u),gid=$(id -g) /dev/sda1 ~/usb_work/snapshots &&

podman-compose -f /home/birdhead/usb_work/podman/bigdata-server/docker-compose.yml down &&  podman-compose -f /home/birdhead/usb_work/podman/bigdata-server/docker-compose.yml up -d && podman ps -a 

echo "마운트가 완료되었습니다."
ls -al ~/usb_work && cd ~/usb_work
