#!/bin/bash
# =================================================================
# Btrfs 스냅샷 복원 스크립트 (최종 완성 v3)
# =================================================================
set -e

# --- 설정 ---
DEVICE="UUID=56870639-72c9-4a55-b0d2-81dfe499daa7"
ADMIN_MOUNT="/mnt/btrfs_admin"

if [ "$#" -ne 1 ]; then echo "오류: 스냅샷 이름 필요"; exit 1; fi
SNAPSHOT_NAME=$1

read -p "경고: '$SNAPSHOT_NAME'(으)로 복원합니다. 계속하시겠습니까? (y/n): " confirm
if [[ "$confirm" != "y" && "$confirm" != "Y" ]]; then echo "취소됨"; exit 0; fi

echo "✅ 복원을 시작합니다..."
set +e
sudo umount /home/birdhead/usb_work/snapshot 2>/dev/null
sudo umount /home/birdhead/usb_work 2>/dev/null
set -e

# 1. 관리자 마운트
sudo mkdir -p "$ADMIN_MOUNT"
sudo mount -o subvolid=5 "$DEVICE" "$ADMIN_MOUNT"

# 2. 복원할 스냅샷으로 'restored_temp' 임시 서브볼륨을 먼저 생성
echo "[1/4] 스냅샷으로 임시 복원 공간을 생성합니다..."
RESTORE_TEMP_PATH="$ADMIN_MOUNT/restored_temp_$(date +%s)"
sudo btrfs subvolume snapshot "$ADMIN_MOUNT/snapshots/$SNAPSHOT_NAME" "$RESTORE_TEMP_PATH"

# 3. 새로 만든 임시 공간을 새로운 '기본값'으로 설정
echo "[2/4] 새로운 공간을 기본값으로 설정합니다..."
# ★★★ 바로 여기가 수정된 부분입니다! ★★★
RESTORE_ID=$(sudo btrfs subvolume show "$RESTORE_TEMP_PATH" | grep 'Subvolume ID' | awk '{print $3}')
sudo btrfs subvolume set-default "$RESTORE_ID" "$ADMIN_MOUNT"

# 4. 이제 구 'work_data'는 더 이상 기본값이 아니므로 안전하게 삭제 가능
# (이미 수동으로 삭제했지만, 스크립트의 안정성을 위해 코드는 남겨둡니다)
echo "[3/4] 이전 작업 공간('work_data')을 삭제합니다..."
if [ -d "$ADMIN_MOUNT/work_data" ]; then
    sudo btrfs property set -ts "$ADMIN_MOUNT/work_data" ro false
    sudo btrfs subvolume delete "$ADMIN_MOUNT/work_data"
fi

# 5. 임시 이름을 최종 이름 'work_data'로 변경
echo "[4/4] 복원된 공간의 이름을 'work_data'로 변경합니다..."
sudo mv "$RESTORE_TEMP_PATH" "$ADMIN_MOUNT/work_data"

sudo umount "$ADMIN_MOUNT"
echo -e "\n🎉 복원 완료! 'mount_usb_work.sh'로 마운트하세요."
