#!/bin/bash
# =================================================================
# Btrfs USB SSD 초기 설정 스크립트 (한 번만 실행)
# =================================================================
set -e # 오류 발생 시 즉시 스크립트 중단

echo "Btrfs USB SSD 초기 설정을 시작합니다..."

# 1. 관리를 위한 임시 마운트
echo "[1/6] Btrfs 최상위 루트를 임시 마운트합니다..."
sudo mkdir -p /mnt/btrfs_admin
sudo mount -o subvolid=5 /dev/sda1 /mnt/btrfs_admin

# 2. "백업 창고" 역할을 할 snapshots 서브볼륨 생성
echo "[2/6] 'snapshots' 서브볼륨을 생성합니다..."
sudo btrfs subvolume create /mnt/btrfs_admin/snapshots

# 3. "우리 집" 역할을 할 work_data 서브볼륨 생성
echo "[3/6] 'work_data' 서브볼륨을 생성합니다..."
sudo btrfs subvolume create /mnt/btrfs_admin/work_data

# 4. 이제 usb_work를 마운트할 때 기본으로 "우리 집"이 열리도록 설정
echo "[4/6] 'work_data'를 기본 마운트 서브볼륨으로 설정합니다..."
WORK_DATA_ID=$(sudo btrfs subvolume show /mnt/btrfs_admin/work_data | grep 'Subvolume ID' | awk '{print $3}')
sudo btrfs subvolume set-default "$WORK_DATA_ID" /mnt/btrfs_admin

# 5. 관리용 임시 마운트 해제 및 정리
echo "[5/6] 임시 마운트를 해제하고 정리합니다..."
sudo umount /mnt/btrfs_admin
sudo rmdir /mnt/btrfs_admin

# 6. 앞으로 사용할 마운트 포인트 폴더 준비
echo "[6/6] 마운트 포인트 폴더를 준비합니다..."
mkdir -p ~/usb_work/snapshots

echo -e "\n✅ 초기 설정이 완료되었습니다. 이제 'mount_usb_work.sh' 스크립트를 사용해 마운트하세요."
