#!/bin/bash
# =================================================================
# Btrfs USB SSD 언마운트 스크립트
# =================================================================
set -e

echo "Btrfs 볼륨을 안전하게 언마운트합니다..."

# 1. 중첩된 마운트 포인트부터 먼저 해제 (오류를 무시하고 계속 진행)
echo "Attempting to unmount snapshot directory..."
sudo umount ~/usb_work/snapshots 2>/dev/null || true

echo "Try to down for podman-compose"
# podman-compose가 실패할 수도 있으므로 오류 무시 처리
podman-compose -f /home/birdhead/usb_work/podman/bigdata-server/docker-compose.yml down 2>/dev/null || true

# 프로세스를 강제 종료하고 메시지를 출력하지 않도록 -s 옵션 추가
echo "Checking for any remaining processes..."
sudo fuser -ksm ~/usb_work 2>/dev/null || true

# 2. 상위 마운트 포인트 해제 (오류를 무시하고 계속 진행)
echo "Attempting to unmount main directory..."
sudo umount ~/usb_work 2>/dev/null || true

echo "언마운트가 완료되었습니다."
